<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/**
* @package direct-as-a-service
* @subpackage libraries
* @filesource
*/ /** */

// ------------------------------------------------------------------------
require_once BASEPATH.'libraries/Email.php';


/**
* @package direct-as-a-service
* @subpackage libraries
*/
class DPII_Email extends CI_Email{
	
	//vars for extended functionality
	var $_attach_source = array(); //added to store source of attachment - file or string
	var $_attach_content = array(); //and attachment content - only relevant for string attachments.
	#var $_mdn_message_id = null;  //conventionally, we don't declare class vars as null in PHP - it will be null by default -- MG 2014-05-15
	var $_mdn_message_id;  //sets the message id of the original message if message is a display mdn
	
	//vars for VLER config - as long as we have standard values, might as well set them here
	var $smtp_host = GATEWAY_SMTP_HOSTNAME;
    var $smtp_port = GATEWAY_SMTP_PORT;
	var $protocol = DIRECT_SEND_PROTOCOL;
	var $smtp_timeout = GATEWAY_SMTP_TIMEOUT;
	

	/** Overrides parent to include _attach_source and _attach_content in clear */
	public function clear($clear_attachments = FALSE)
	{
		parent::clear($clear_attachments);	
		if ($clear_attachments !== FALSE)
		{
			//clearing additional arrays for string attachment
			$this->_attach_source = array();
			$this->_attach_content = array();
#			$this->_mdn_message_id = null; //we want this to be set to null whether or not there were attachments, yes?  -- MG 2014-05-15
		}
		$this->_mdn_message_id = null;

		return $this;
	}


	/** Overrides parent to ignore CI's magic quotes check 
	* @todo Is this actually a check that we want to strip out?
	*/
	public function message($body)
	{
		$this->_body = stripslashes(rtrim(str_replace("\r", "", $body)));
		return $this;
	}

	// --------------------------------------------------------------------

	/**
	 * Overrides parent to make use of {@link _attach_disp}, {@link _attach_source} 
	 */
	public function attach($filename, $disposition = '', $newname = NULL)
	{
		$this->_attach_name[] = array($filename, $newname);
		$this->_attach_type[] = $this->_mime_types(pathinfo($filename, PATHINFO_EXTENSION));
		$this->_attach_disp[] = empty($disposition) ? 'attachment' : $disposition; // Can also be 'inline'  Not sure if it matters
		
		$this->_attach_source[] = 'file'; //added source variable
		
		return $this;
	}
	
	/**
	 * Added to assign string attachments.
	 *
	 * @param	string
	 * @return	void
	 */
	public function string_attach($str_file, $filename, $mime = null, $disposition = 'attachment')
	{
		if(!isset($mime)) { $mime = $this->_mime_types(pathinfo($filename, PATHINFO_EXTENSION)); }
		$this->_attach_name[] = $filename;
		$this->_attach_type[] = $mime;
		$this->_attach_disp[] = $disposition; // Can also be 'inline'  Not sure if it matters
		$this->_attach_source[] = 'string';
		$this->_attach_content[] = $str_file;

		return $this;
	}


	/** Overrides parent to check if the string is empty; it's not clear to me why this needed to happen.  Note that if the dev is actually trying to check if we're getting an empty value other than the empty string, it would be helpful to explicitly check is_null() or leave a comment that explains what they're trying to do. */
	public function set_alt_message($str = '')
	{
		$this->alt_message = ($str == '') ? '' : $str;
		return $this;
	}
	
	/**
	 * Set Custom header
	 *
	 * @access	public
	 * @param	string
	 * @param	string
	 * @return	void
	 */
/* Can we rename this to set_custom_header?  It's confusing having unrelated _set_header and set_header methods -- MG 2014-05-14 */	 
	public function set_header($header, $value){
		$this->_headers[$header] = $value;
	}	
	

	// --------------------------------------------------------------------

	/** 
	* Overrides parent to allow for string attachments & provide a case for sending MDNs (message receipts)
	* @todo It would probably be better for MDN code to be in a child library, so that there's no chance they'll be accidentally sent from the standard library if someone forgets to 
	* clear() the variables.
	 */
	protected function _build_message()
	{
		if ($this->wordwrap === TRUE  AND  $this->mailtype != 'html')
		{
			$this->_body = $this->word_wrap($this->_body);
		}

		$this->_set_boundaries();
		$this->_write_headers();

		$hdr = ($this->_get_protocol() == 'mail') ? $this->newline : '';
		$body = '';
		

		switch ($this->_get_content_type())
		{
			case 'plain' :

				$hdr .= "Content-Type: text/plain; charset=" . $this->charset . $this->newline;
				$hdr .= "Content-Transfer-Encoding: " . $this->_get_encoding();

				if ($this->_get_protocol() == 'mail')
				{
					$this->_header_str .= $hdr;
					$this->_finalbody = $this->_body;
				}
				else
				{
					$this->_finalbody = $hdr . $this->newline . $this->newline . $this->_body;
				}

				return;

			break;
			case 'html' :

				if ($this->send_multipart === FALSE)
				{
					$hdr .= "Content-Type: text/html; charset=" . $this->charset . $this->newline;
					$hdr .= "Content-Transfer-Encoding: quoted-printable";
				}
				else
				{
					$hdr .= "Content-Type: multipart/alternative; boundary=\"" . $this->_alt_boundary . "\"" . $this->newline . $this->newline;

					$body .= $this->_get_mime_message() . $this->newline . $this->newline;
					$body .= "--" . $this->_alt_boundary . $this->newline;

					$body .= "Content-Type: text/plain; charset=" . $this->charset . $this->newline;
					$body .= "Content-Transfer-Encoding: " . $this->_get_encoding() . $this->newline . $this->newline;
					$body .= $this->_get_alt_message() . $this->newline . $this->newline . "--" . $this->_alt_boundary . $this->newline;

					$body .= "Content-Type: text/html; charset=" . $this->charset . $this->newline;
					$body .= "Content-Transfer-Encoding: quoted-printable" . $this->newline . $this->newline;
				}

				$this->_finalbody = $body . $this->_prep_quoted_printable($this->_body) . $this->newline . $this->newline;


				if ($this->_get_protocol() == 'mail')
				{
					$this->_header_str .= $hdr;
				}
				else
				{
					$this->_finalbody = $hdr . $this->_finalbody;
				}


				if ($this->send_multipart !== FALSE)
				{
					$this->_finalbody .= "--" . $this->_alt_boundary . "--";
				}

				return;

			break;
			case 'plain-attach' :

				$hdr .= "Content-Type: multipart/".$this->multipart."; boundary=\"" . $this->_atc_boundary."\"" . $this->newline . $this->newline;

				if ($this->_get_protocol() == 'mail')
				{
					$this->_header_str .= $hdr;
				}

				$body .= $this->_get_mime_message() . $this->newline . $this->newline;
				$body .= "--" . $this->_atc_boundary . $this->newline;

				$body .= "Content-Type: text/plain; charset=" . $this->charset . $this->newline;
				$body .= "Content-Transfer-Encoding: " . $this->_get_encoding() . $this->newline . $this->newline;

				$body .= $this->_body . $this->newline . $this->newline;

			break;
			case 'html-attach' :

				$hdr .= "Content-Type: multipart/".$this->multipart."; boundary=\"" . $this->_atc_boundary."\"" . $this->newline . $this->newline;

				if ($this->_get_protocol() == 'mail')
				{
					$this->_header_str .= $hdr;
				}

				$body .= $this->_get_mime_message() . $this->newline . $this->newline;
				$body .= "--" . $this->_atc_boundary . $this->newline;

				$body .= "Content-Type: multipart/alternative; boundary=\"" . $this->_alt_boundary . "\"" . $this->newline .$this->newline;
				$body .= "--" . $this->_alt_boundary . $this->newline;

				$body .= "Content-Type: text/plain; charset=" . $this->charset . $this->newline;
				$body .= "Content-Transfer-Encoding: " . $this->_get_encoding() . $this->newline . $this->newline;
				$body .= $this->_get_alt_message() . $this->newline . $this->newline . "--" . $this->_alt_boundary . $this->newline;

				$body .= "Content-Type: text/html; charset=" . $this->charset . $this->newline;
				$body .= "Content-Transfer-Encoding: quoted-printable" . $this->newline . $this->newline;

				$body .= $this->_prep_quoted_printable($this->_body) . $this->newline . $this->newline;
				$body .= "--" . $this->_alt_boundary . "--" . $this->newline . $this->newline;

			break;
		}
	
		$attachment = array();

		$z = 0;
		
/* START CHANGES TO PARENT VERSION */		
		//replacing parent version to allow string attachments
		for ($i=0; $i < count($this->_attach_name); $i++)
		{
			$filename = $this->_attach_name[$i];
			$basename = basename($filename);
			$ctype = $this->_attach_type[$i];

			if($this->_attach_source[$i] == 'file')
			{
				if ( ! file_exists($filename))
				{
					$this->_set_error_message('lang:email_attachment_missing', $filename);
					return FALSE;
				}

				$file = filesize($filename) +1;

				if ( ! $fp = fopen($filename, FOPEN_READ))
				{
					$this->_set_error_message('lang:email_attachment_unreadable', $filename);
					return FALSE;
				}

				$file_content = fread($fp, $file);
				fclose($fp);
			}
			else
			{
				$file_content =& $this->_attach_content[$i];
			}

			$h  = "--".$this->_atc_boundary.$this->newline;
			$h .= "Content-type: ".$ctype."; ";
			$h .= "name=\"".$basename."\"".$this->newline;
			$h .= "Content-Disposition: ".$this->_attach_disp[$i].";".$this->newline;
			$h .= "Content-Transfer-Encoding: base64".$this->newline;

			$attachment[$z++] = $h;
			$attachment[$z++] = chunk_split(base64_encode($file_content));
		}
/* END MODIFICATIONS TO PARENT VERSION */		

		$body .= implode($this->newline, $attachment).$this->newline."--".$this->_atc_boundary."--";


		if ($this->_get_protocol() == 'mail')
		{
			$this->_finalbody = $body;
		}
		else
		{
			$this->_finalbody = $hdr . $body;
		}

		return;
	}


	// --------------------------------------------------------------------

	/** Overrides parent, apparently to remove ssl?
	* @todo Do we really want to remove ssl?
	*/
	protected function _smtp_connect()
	{
		$this->_smtp_connect = fsockopen($this->smtp_host,
										$this->smtp_port,
										$errno,
										$errstr,
										$this->smtp_timeout);

		if ( ! is_resource($this->_smtp_connect))
		{
			$this->_set_error_message('lang:email_smtp_error', $errno." ".$errstr);
			return FALSE;
		}

		$this->_set_error_message($this->_get_smtp_data());
		return $this->_send_command('hello');
	}

	// --------------------------------------------------------------------

	/**
	 * Overrides parent, so that if connection fails it does not try to write.
	 *
	 * @access	protected
	 * @return	bool
	 */
	protected function _send_with_smtp()
	{
		if ($this->smtp_host == '')
		{
			$this->_set_error_message('lang:email_no_hostname');
			return FALSE;
		}

/* START CHANGE TO PARENT VERSION */
		if(!$this->_smtp_connect()){
			return FALSE;
		}
/* END CHANGE TO PARENT VERSION */
		$this->_smtp_authenticate();

		$this->_send_command('from', $this->clean_email($this->_headers['From']));

		foreach ($this->_recipients as $val)
		{
			$this->_send_command('to', $val);
		}

		if (count($this->_cc_array) > 0)
		{
			foreach ($this->_cc_array as $val)
			{
				if ($val != "")
				{
					$this->_send_command('to', $val);
				}
			}
		}

		if (count($this->_bcc_array) > 0)
		{
			foreach ($this->_bcc_array as $val)
			{
				if ($val != "")
				{
					$this->_send_command('to', $val);
				}
			}
		}

		$this->_send_command('data');

		// perform dot transformation on any lines that begin with a dot
		$this->_send_data($this->_header_str . preg_replace('/^\./m', '..$1', $this->_finalbody));

		$this->_send_data('.');

		$reply = $this->_get_smtp_data();

		$this->_set_error_message($reply);

		if (strncmp($reply, '250', 3) != 0)
		{
			$this->_set_error_message('lang:email_smtp_error', $reply);
			return FALSE;
		}

		$this->_send_command('quit');
		return TRUE;
	}

	/** Overrides parent to use multibyte-safe string methods */
	public function word_wrap($str, $charlim = '')
	{
		// Se the character limit
		if ($charlim == '')
		{
			$charlim = ($this->wrapchars == "") ? "76" : $this->wrapchars;
		}

		// Reduce multiple spaces
		$str = preg_replace("| +|", " ", $str);

		// Standardize newlines
		if (mb_strpos($str, "\r") !== FALSE)
		{
			$str = str_replace(array("\r\n", "\r"), "\n", $str);
		}

		// If the current word is surrounded by {unwrap} tags we'll
		// strip the entire chunk and replace it with a marker.
		$unwrap = array();
		if (preg_match_all("|(\{unwrap\}.+?\{/unwrap\})|s", $str, $matches))
		{
			for ($i = 0; $i < count($matches['0']); $i++)
			{
				$unwrap[] = $matches['1'][$i];
				$str = str_replace($matches['1'][$i], "{{unwrapped".$i."}}", $str);
			}
		}

		// Use PHP's native public function to do the initial wordwrap.
		// We set the cut flag to FALSE so that any individual words that are
		// too long get left alone.  In the next step we'll deal with them.
		$str = mb_wordwrap($str, $charlim, "\n", FALSE);

		// Split the string into individual lines of text and cycle through them
		$output = "";
		foreach (explode("\n", $str) as $line)
		{
			// Is the line within the allowed character count?
			// If so we'll join it to the output and continue
			if (mb_strlen($line) <= $charlim)
			{
				$output .= $line.$this->newline;
				continue;
			}

			$temp = '';
			while ((mb_strlen($line)) > $charlim)
			{
				// If the over-length word is a URL we won't wrap it
				if (preg_match("!\[url.+\]|://|wwww.!", $line))
				{
					break;
				}

				// Trim the word down
				$temp .= mb_substr($line, 0, $charlim-1);
				$line = mb_substr($line, $charlim-1);
			}

			// If $temp contains data it means we had to split up an over-length
			// word into smaller chunks so we'll add it back to our current line
			if ($temp != '')
			{
				$output .= $temp.$this->newline.$line;
			}
			else
			{
				$output .= $line;
			}

			$output .= $this->newline;
		}

		// Put our markers back
		if (count($unwrap) > 0)
		{
			foreach ($unwrap as $key => $val)
			{
				$output = str_replace("{{unwrapped".$key."}}", $val, $output);
			}
		}

		return $output;
	}

	/** 
	* Overrides parent to be safe with multibyte strings.
	* The CI version of this method tries to iterate through the characters of a string, 
	* but they don't do so in a way that's safe for UTF-8 strings.
	*/
	protected function _prep_quoted_printable($str, $charlim = '')
	{
		// Set the character limit
		// Don't allow over 76, as that will make servers and MUAs barf
		// all over quoted-printable data
		if ($charlim == '' OR $charlim > '76')
		{
			$charlim = '76';
		}
	
		// Reduce multiple spaces
		$str = preg_replace("| +|", " ", $str);

		// kill nulls
		$str = preg_replace('/\x00+/', '', $str);
		

		// Standardize newlines
		if(string_contains("\r", $str))
		{
			$str = str_replace(array("\r\n", "\r"), "\n", $str);
		}

		// We are intentionally wrapping so mail servers will encode characters
		// properly and MUAs will behave, so {unwrap} must go!
		$str = str_replace(array('{unwrap}', '{/unwrap}'), '', $str);

		// Break into an array of lines
		$lines = explode("\n", $str);

		$escape = '=';
		$output = '';
/* START CHANGES FROM PARENT */
		foreach ($lines as $line)
		{
			$processed_line = '';
			
			$characters = preg_split('/(?<!^)(?!$)/u', $line);
			
			foreach($characters as $i => $char){
				$ascii = ord($char); //for multibyte chars, this will default to 244, but I think that's that's OK - we're just checking for whitespace
				
				// Convert spaces and tabs but only if it's the end of the line
				if ($i == array_last_key($characters) && ($ascii == '32' OR $ascii == '9') ){
					$char = $escape.sprintf('%02s', dechex($ascii));
				}
								
				// encode = signs
				if ($ascii == '61'){
					$char = $escape.mb_strtoupper(sprintf('%02s', dechex($ascii)));  // =3D
				}
				
				// If we're at the character limit, add the line to the output, reset our temp variable, and keep on chuggin'
				if ((mb_strlen($processed_line) + mb_strlen($char)) >= $charlim){
					$output .= $processed_line.$escape.$this->crlf;
					$processed_line = '';
				}
				
				$processed_line .= $char;
			}
			
			$output .= $processed_line.$this->crlf;
		}

		// get rid of extra CRLF tacked onto the end
		$output = strip_from_end($this->crlf, $output);
/* END CHANGES FROM PARENT */

		return $output;
	}

	/** Overrides parent to be safe with multi-byte strings */
	protected function _prep_q_encoding($str, $from = FALSE)
	{
		$str = str_replace(array("\r", "\n"), array('', ''), $str);

		// Line length must not exceed 76 characters, so we adjust for
		// a space, 7 extra characters =??Q??=, and the charset that we will add to each line
		$limit = 75 - 7 - mb_strlen($this->charset);

		// these special characters must be converted too
		$convert = array('_', '=', '?');

		if ($from === TRUE)
		{
			$convert[] = ',';
			$convert[] = ';';
		}

		$output = '';
		$temp = '';
		
		$characters = preg_split('/(?<!^)(?!$)/u', $str);
		
		foreach($characters as $i => $char){
			$ascii = ord($char);

			// convert ALL non-printable ASCII characters and our specials
			if ( (chr($ascii) == $char && ($ascii < 32 OR $ascii > 126)) OR in_array($char, $convert))
			{
				$char = '='.dechex($ascii);
			}

			// handle regular spaces a bit more compactly than =20
			if ($ascii == 32)
			{
				$char = '_';
			}

			// If we're at the character limit, add the line to the output,
			// reset our temp variable, and keep on chuggin'
			if ((mb_strlen($temp) + mb_strlen($char)) >= $limit)
			{
				$output .= $temp.$this->crlf;
				$temp = '';
			}

			// Add the character to our temporary line
			$temp .= $char;
		}

		$str = $output.$temp;

		// wrap each line with the shebang, charset, and transfer encoding
		// the preceding space on successive lines is required for header "folding"
		$str = trim(preg_replace('/^(.*)$/m', ' =?'.$this->charset.'?Q?$1?=', $str));

		return $str;
	}
	
	/** Overrides parent to use multibyte-safe string functions */
	public function batch_bcc_send()
	{
		$float = $this->bcc_batch_size -1;

		$set = "";

		$chunk = array();

		for ($i = 0; $i < count($this->_bcc_array); $i++)
		{
			if (isset($this->_bcc_array[$i]))
			{
				$set .= ", ".$this->_bcc_array[$i];
			}

			if ($i == $float)
			{
				$chunk[] = mb_substr($set, 1);
				$float = $float + $this->bcc_batch_size;
				$set = "";
			}

			if ($i == count($this->_bcc_array)-1)
			{
				$chunk[] = mb_substr($set, 1);
			}
		}

		for ($i = 0; $i < count($chunk); $i++)
		{
			unset($this->_headers['Bcc']);
			unset($bcc);

			$bcc = $this->_str_to_array($chunk[$i]);
			$bcc = $this->clean_email($bcc);

			if ($this->protocol != 'smtp')
			{
				$this->_set_header('Bcc', implode(", ", $bcc));
			}
			else
			{
				$this->_bcc_array = $bcc;
			}

			$this->_build_message();
			$this->_spool_email();
		}
	}	
	
	/** 
	* Overrides parent to use multibyte-safe string functions 
	* Also, the original override commented out the starttls case.  Not sure why it was necessary to comment this out instead of just not using the starttls case.
	*/
	protected function _send_command($cmd, $data = '')
	{
		switch ($cmd)
		{
			case 'hello' :

					if ($this->_smtp_auth OR $this->_get_encoding() == '8bit')
						$this->_send_data('EHLO '.$this->_get_hostname());
					else
						$this->_send_data('HELO '.$this->_get_hostname());

						$resp = 250;
			break;
			/*case 'starttls'	:
						$this->_send_data('STARTTLS');

						$resp = 220;
			break;*/
			case 'from' :

						$this->_send_data('MAIL FROM:<'.$data.'>');

						$resp = 250;
			break;
			case 'to'	:

						$this->_send_data('RCPT TO:<'.$data.'>');

						$resp = 250;
			break;
			case 'data'	:

						$this->_send_data('DATA');

						$resp = 354;
			break;
			case 'quit'	:

						$this->_send_data('QUIT');

						$resp = 221;
			break;
		}

		$reply = $this->_get_smtp_data();

		$this->_debug_msg[] = "<pre>".$cmd.": ".$reply."</pre>";

		if(mb_substr($reply, 0, 3) != $resp){
			$this->_set_error_message('lang:email_smtp_error', $reply);
			return FALSE;
		}

		if ($cmd == 'quit')
		{
			fclose($this->_smtp_connect);
		}

		return TRUE;
	}

	
	/** Overrides parent to use multibyte-safe string functions */
	protected function _get_smtp_data(){
		$data = "";

		while ($str = fgets($this->_smtp_connect, 512))
		{
			$data .= $str;

			if (mb_substr($str, 3, 1) == " ")
			{
				break;
			}
		}

		return $data;
	}
	
	/** Overrides parent to use multibyte-safe string functions */
	protected function _set_error_message($msg, $val = '')
	{
		$CI =& get_instance();
		$CI->lang->load('email');

		if (mb_substr($msg, 0, 5) != 'lang:' || FALSE === ($line = $CI->lang->line(mb_substr($msg, 5))))
		{
			$this->_debug_msg[] = str_replace('%s', $val, $msg)."<br />";
		}
		else
		{
			$this->_debug_msg[] = str_replace('%s', $val, $line)."<br />";
		}
	}	


}
// END DPII_Email class

/* End of file Email.php */
/* Location: ./application/libraries/DPII_Email.php */
